<?php
/**
 * The template for displaying single posts
 *
 * @package Dreamformer_WooCommerce
 */

get_header(); ?>

<main class="site-main" id="main-content">
    <div class="container">
        <?php while ( have_posts() ) : the_post(); ?>

            <article id="post-<?php the_ID(); ?>" <?php post_class( 'single-post' ); ?>>
                <header class="post-header">
                    <h1 class="post-title"><?php the_title(); ?></h1>

                    <div class="post-meta">
                        <?php
                        dreamformer_woocommerce_posted_on();
                        dreamformer_woocommerce_posted_by();
                        ?>
                    </div>
                </header>

                <?php if ( has_post_thumbnail() ) : ?>
                    <div class="post-thumbnail">
                        <?php the_post_thumbnail( 'large' ); ?>
                    </div>
                <?php endif; ?>

                <div class="post-content">
                    <?php
                    the_content( sprintf(
                        wp_kses(
                            /* translators: %s: Name of current post. Only visible to screen readers */
                            __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'dreamformer-woocommerce' ),
                            array(
                                'span' => array(
                                    'class' => array(),
                                ),
                            )
                        ),
                        wp_kses_post( get_the_title() )
                    ) );

                    wp_link_pages( array(
                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'dreamformer-woocommerce' ),
                        'after'  => '</div>',
                    ) );
                    ?>
                </div>

                <footer class="post-footer">
                    <?php
                    // Show post categories
                    $categories_list = get_the_category_list( esc_html__( ', ', 'dreamformer-woocommerce' ) );
                    if ( $categories_list ) {
                        printf(
                            '<div class="post-categories"><span class="cat-links">' . esc_html__( 'Posted in %1$s', 'dreamformer-woocommerce' ) . '</span></div>',
                            $categories_list // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        );
                    }

                    // Show post tags
                    $tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'dreamformer-woocommerce' ) );
                    if ( $tags_list ) {
                        printf(
                            '<div class="post-tags"><span class="tags-links">' . esc_html__( 'Tagged %1$s', 'dreamformer-woocommerce' ) . '</span></div>',
                            $tags_list // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        );
                    }
                    ?>
                </footer>
            </article>

            <?php
            // Post navigation
            the_post_navigation( array(
                'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'dreamformer-woocommerce' ) . '</span> <span class="nav-title">%title</span>',
                'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'dreamformer-woocommerce' ) . '</span> <span class="nav-title">%title</span>',
            ) );

            // Show comments if enabled
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
            ?>

        <?php endwhile; ?>
    </div>
</main>

<?php get_footer(); ?>
