<?php
/**
 * The template for displaying all pages
 *
 * @package Dreamformer_WooCommerce
 */

get_header(); ?>

<main class="site-main" id="main-content" role="main">
    <?php while ( have_posts() ) : the_post();
        $is_ai_page = get_post_meta( get_the_ID(), 'ai_generated_page', true );

        // AI pages get no wrapper - full creative control
        if ( $is_ai_page ) :
            // Get protected content from meta field to avoid editor corruption
            // Note: Plugin filter automatically returns draft content in preview mode
            $protected_content = get_post_meta( get_the_ID(), '_ai_protected_content', true );
            if ( $protected_content ) {
                // AI-generated content is trusted - output directly
                // Note: wp_kses_post() was removed because it strips form elements
                echo do_shortcode( $protected_content );
            } else {
                // Fallback to regular content for older pages
                the_content();
            }
            ?>

        <?php else : ?>
            <!-- Regular pages keep the standard layout -->
            <section class="content-section" id="content">
                <div class="container">
                    <article id="page-<?php the_ID(); ?>" <?php post_class( 'page-content' ); ?>>
                        <header class="page-header">
                            <h1 class="page-title"><?php the_title(); ?></h1>
                        </header>

                        <div class="page-content-wrapper">
                            <?php
                            // Display the full page content
                            the_content();

                            // Display page links for multi-page content
                            wp_link_pages( array(
                                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'dreamformer-woocommerce' ),
                                'after'  => '</div>',
                            ) );
                            ?>
                        </div>

                        <?php
                        // Show edit link for logged-in users
                        if ( current_user_can( 'edit_posts' ) ) {
                            edit_post_link(
                                sprintf(
                                    wp_kses(
                                        __( 'Edit <span class="screen-reader-text">%s</span>', 'dreamformer-woocommerce' ),
                                        array(
                                            'span' => array(
                                                'class' => array(),
                                            ),
                                        )
                                    ),
                                    get_the_title()
                                ),
                                '<footer class="entry-footer"><span class="edit-link">',
                                '</span></footer>'
                            );
                        }
                        ?>
                    </article>
                </div>
            </section>
        <?php endif; ?>
    <?php endwhile; ?>
</main>

<?php get_footer(); ?>
