<?php
/**
 * The main template file
 *
 * @package Dreamformer_WooCommerce
 */

get_header(); ?>

<main class="site-main" id="main-content" role="main">
    <?php if ( is_home() || is_front_page() ) : ?>

        <!-- Hero Section -->
        <section class="hero-section" id="hero" aria-labelledby="hero-title">
            <div class="container">
                <h1 class="hero-title" id="hero-title"><?php bloginfo( 'name' ); ?></h1>
                <p class="hero-description"><?php bloginfo( 'description' ); ?></p>
                <a href="#features" class="button button--primary button--large" aria-describedby="hero-title">
                    <?php esc_html_e( 'Get Started', 'dreamformer-woocommerce' ); ?>
                </a>
            </div>
        </section>

        <!-- Features Section -->
        <section class="features-section content-section" id="features" aria-labelledby="features-title">
            <div class="container">
                <h2 class="section-title" id="features-title"><?php esc_html_e( 'Features', 'dreamformer-woocommerce' ); ?></h2>
                <p class="section-description"><?php esc_html_e( 'Discover what makes our solution unique and powerful for your needs.', 'dreamformer-woocommerce' ); ?></p>

                <div class="features-grid" role="group" aria-labelledby="features-title">
                    <article class="feature-card">
                        <h3 class="feature-title"><?php esc_html_e( 'Easy to Use', 'dreamformer-woocommerce' ); ?></h3>
                        <p class="feature-description"><?php esc_html_e( 'Intuitive interface designed for both beginners and professionals.', 'dreamformer-woocommerce' ); ?></p>
                    </article>

                    <article class="feature-card">
                        <h3 class="feature-title"><?php esc_html_e( 'Fast & Reliable', 'dreamformer-woocommerce' ); ?></h3>
                        <p class="feature-description"><?php esc_html_e( 'Built with performance in mind, ensuring quick load times and reliability.', 'dreamformer-woocommerce' ); ?></p>
                    </article>

                    <article class="feature-card">
                        <h3 class="feature-title"><?php esc_html_e( 'Fully Customizable', 'dreamformer-woocommerce' ); ?></h3>
                        <p class="feature-description"><?php esc_html_e( 'Adapt every aspect to match your brand and business requirements.', 'dreamformer-woocommerce' ); ?></p>
                    </article>
                </div>
            </div>
        </section>

        <!-- Testimonials Section -->
        <section class="testimonials-section content-section" id="testimonials" aria-labelledby="testimonials-title">
            <div class="container">
                <h2 class="section-title" id="testimonials-title"><?php esc_html_e( 'What Our Customers Say', 'dreamformer-woocommerce' ); ?></h2>
                <p class="section-description"><?php esc_html_e( 'See how we\'ve helped businesses like yours achieve their goals.', 'dreamformer-woocommerce' ); ?></p>

                <div class="testimonials-grid" role="group" aria-labelledby="testimonials-title">
                    <article class="testimonial-card">
                        <blockquote class="testimonial-quote">
                            <p><?php esc_html_e( 'This solution transformed how we work. The results exceeded our expectations and the support team was incredible.', 'dreamformer-woocommerce' ); ?></p>
                        </blockquote>
                        <footer class="testimonial-author" aria-label="<?php esc_attr_e( 'Testimonial author', 'dreamformer-woocommerce' ); ?>">
                            <?php esc_html_e( 'Sarah Johnson, CEO', 'dreamformer-woocommerce' ); ?>
                        </footer>
                    </article>

                    <article class="testimonial-card">
                        <blockquote class="testimonial-quote">
                            <p><?php esc_html_e( 'Simple to implement and powerful in execution. It\'s exactly what our team needed to scale our operations.', 'dreamformer-woocommerce' ); ?></p>
                        </blockquote>
                        <footer class="testimonial-author" aria-label="<?php esc_attr_e( 'Testimonial author', 'dreamformer-woocommerce' ); ?>">
                            <?php esc_html_e( 'Michael Chen, CTO', 'dreamformer-woocommerce' ); ?>
                        </footer>
                    </article>

                    <article class="testimonial-card">
                        <blockquote class="testimonial-quote">
                            <p><?php esc_html_e( 'The customization options are endless. We were able to create exactly the experience our customers wanted.', 'dreamformer-woocommerce' ); ?></p>
                        </blockquote>
                        <footer class="testimonial-author" aria-label="<?php esc_attr_e( 'Testimonial author', 'dreamformer-woocommerce' ); ?>">
                            <?php esc_html_e( 'Emma Davis, Designer', 'dreamformer-woocommerce' ); ?>
                        </footer>
                    </article>
                </div>
            </div>
        </section>

    <?php else : ?>

        <!-- Blog/Archive Content -->
        <section class="content-section" id="content">
            <div class="container">
                <?php if ( have_posts() ) : ?>

                    <div class="posts-container">
                        <?php while ( have_posts() ) : the_post(); ?>

                            <article id="post-<?php the_ID(); ?>" <?php post_class( 'post-card' ); ?>>
                                <header class="post-header">
                                    <h2 class="post-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h2>

                                    <div class="post-meta">
                                        <?php
                                        dreamformer_woocommerce_posted_on();
                                        dreamformer_woocommerce_posted_by();
                                        ?>
                                    </div>
                                </header>

                                <div class="post-content">
                                    <?php
                                    if ( has_post_thumbnail() ) {
                                        echo '<div class="post-thumbnail">';
                                        the_post_thumbnail( 'large' );
                                        echo '</div>';
                                    }

                                    the_excerpt();
                                    ?>
                                </div>

                                <footer class="post-footer">
                                    <a href="<?php the_permalink(); ?>" class="read-more-link button">
                                        <?php esc_html_e( 'Read More', 'dreamformer-woocommerce' ); ?>
                                    </a>
                                </footer>
                            </article>

                        <?php endwhile; ?>
                    </div>

                    <?php
                    // Pagination
                    the_posts_pagination( array(
                        'prev_text' => esc_html__( 'Previous', 'dreamformer-woocommerce' ),
                        'next_text' => esc_html__( 'Next', 'dreamformer-woocommerce' ),
                    ) );
                    ?>

                <?php else : ?>

                    <div class="no-posts">
                        <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'dreamformer-woocommerce' ); ?></h1>
                        <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'dreamformer-woocommerce' ); ?></p>
                        <?php get_search_form(); ?>
                    </div>

                <?php endif; ?>
            </div>
        </section>

    <?php endif; ?>
</main>

<?php get_footer(); ?>
