<?php
/**
 * The header for our theme
 *
 * @package Dreamformer_WooCommerce
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div class="site-wrapper">
    <header class="site-header" id="site-header" role="banner">
        <div class="container">
            <div class="header-content">
                <div class="site-branding">
                    <?php
                    if ( has_custom_logo() ) {
                        the_custom_logo();
                    } else {
                        ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-title" rel="home" aria-label="<?php echo esc_attr( get_bloginfo( 'name' ) . ' - ' . __( 'Go to homepage', 'dreamformer-woocommerce' ) ); ?>">
                            <?php bloginfo( 'name' ); ?>
                        </a>
                        <?php
                        $description = get_bloginfo( 'description', 'display' );
                        if ( $description || is_customize_preview() ) {
                            ?>
                            <p class="site-description"><?php echo esc_html( $description ); ?></p>
                            <?php
                        }
                    }
                    ?>
                </div>

                <button class="mobile-menu-toggle" id="mobile-menu-toggle" aria-label="<?php esc_attr_e( 'Toggle mobile menu', 'dreamformer-woocommerce' ); ?>" aria-expanded="false">
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                    <span class="hamburger-line"></span>
                </button>

                <nav class="primary-navigation" id="primary-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'dreamformer-woocommerce' ); ?>">
                    <?php
                    wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'menu_id'        => 'primary-menu',
                        'container'      => false,
                        'menu_class'     => 'nav-menu',
                        'walker'         => new Dreamformer_WooCommerce_Nav_Walker(),
                        'fallback_cb'    => 'dreamformer_woocommerce_fallback_menu',
                    ) );
                    ?>
                </nav>
            </div>
        </div>
    </header>

<?php
/**
 * Fallback menu when no primary menu is set
 */
function dreamformer_woocommerce_fallback_menu() {
    ?>
    <ul class="nav-menu">
        <li class="nav-item">
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="nav-link">
                <?php esc_html_e( 'Home', 'dreamformer-woocommerce' ); ?>
            </a>
        </li>
        <?php
        // Show recent pages as menu items
        $pages = get_pages( array(
            'sort_order' => 'ASC',
            'sort_column' => 'menu_order',
            'number' => 5,
        ) );

        foreach ( $pages as $page ) {
            ?>
            <li class="nav-item">
                <a href="<?php echo esc_url( get_permalink( $page->ID ) ); ?>" class="nav-link">
                    <?php echo esc_html( $page->post_title ); ?>
                </a>
            </li>
            <?php
        }
        ?>
    </ul>
    <?php
}
?>
