<?php
/**
 * The template for displaying the footer
 *
 * @package Dreamformer_Base
 */

?>

    <footer class="site-footer" id="site-footer" role="contentinfo">
        <div class="container">
            <div class="footer-content">
                <?php if ( is_active_sidebar( 'footer-1' ) ) : ?>
                    <div class="footer-widgets" role="complementary" aria-label="<?php esc_attr_e( 'Footer Widgets', 'dreamformer-base' ); ?>">
                        <?php dynamic_sidebar( 'footer-1' ); ?>
                    </div>
                <?php endif; ?>
                
                <div class="footer-info">
                    <?php if ( has_nav_menu( 'footer' ) ) : ?>
                        <nav class="footer-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Footer Menu', 'dreamformer-base' ); ?>">
                            <?php
                            wp_nav_menu( array(
                                'theme_location' => 'footer',
                                'menu_id'        => 'footer-menu',
                                'container'      => false,
                                'menu_class'     => 'footer-menu',
                                'depth'          => 1,
                            ) );
                            ?>
                        </nav>
                    <?php endif; ?>
                    
                    <div class="footer-text" role="contentinfo">
                        <?php
                        $footer_text = ai_base_theme_get_option( 'footer_text', sprintf(
                            /* translators: %s: copyright year and site name */
                            esc_html__( '© %1$s %2$s. All rights reserved.', 'dreamformer-base' ),
                            gmdate( 'Y' ),
                            get_bloginfo( 'name' )
                        ) );
                        echo esc_html( $footer_text );
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </footer>

</div><!-- .site-wrapper -->

<?php wp_footer(); ?>

</body>
</html>