<?php
/**
 * Setup Wizard - First-Run with Feature Overview
 * Uses existing Dreamformer dashboard design system
 *
 * @package AI_Site_Builder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="dreamformer-setup-overlay">
	<div class="setup-modal">

		<!-- Step 0: Feature Overview (NEW) -->
		<div class="setup-step active" data-step="0">
			<div class="setup-header">
				<div class="setup-logo">
					<i data-lucide="sparkles" class="logo-icon"></i>
					<span class="logo-text">Dreamformer</span>
				</div>
				<h1><?php _e( 'Welcome to Dreamformer Studio', 'ai-site-builder' ); ?></h1>
				<p class="setup-subtitle"><?php _e( 'The complete AI-powered website builder', 'ai-site-builder' ); ?></p>
			</div>

			<div class="setup-content">
				<p class="setup-intro"><?php _e( 'Everything you need to build professional WordPress sites:', 'ai-site-builder' ); ?></p>

				<!-- Feature Matrix -->
				<div class="capabilities-grid">

					<!-- CREATE FROM SCRATCH -->
					<div class="capability-section">
						<h3><?php _e( 'Create From Scratch', 'ai-site-builder' ); ?></h3>

						<div class="capability-card">
							<i data-lucide="sparkles" class="capability-icon"></i>
							<h4><?php _e( 'AI Page Generation', 'ai-site-builder' ); ?></h4>
							<p><?php _e( 'Describe any page → Get complete HTML/CSS/JS', 'ai-site-builder' ); ?></p>
							<span class="example"><?php _e( 'Examples: "Landing page", "Pricing page", "Contact page"', 'ai-site-builder' ); ?></span>
						</div>

						<div class="capability-card">
							<i data-lucide="database" class="capability-icon"></i>
							<h4><?php _e( 'Custom Post Types', 'ai-site-builder' ); ?></h4>
							<p><?php _e( 'Create portfolios, team members, testimonials', 'ai-site-builder' ); ?></p>
							<span class="example"><?php _e( 'Examples: "Team showcase", "Case studies"', 'ai-site-builder' ); ?></span>
						</div>
					</div>

					<!-- EDIT & CUSTOMIZE -->
					<div class="capability-section">
						<h3><?php _e( 'Edit & Customize', 'ai-site-builder' ); ?></h3>

						<div class="capability-card">
							<i data-lucide="mouse-pointer-click" class="capability-icon"></i>
							<h4><?php _e( 'Visual Element Editor', 'ai-site-builder' ); ?></h4>
							<p><?php _e( 'Click any element → Edit with AI', 'ai-site-builder' ); ?></p>
							<span class="example"><?php _e( 'Examples: "Make this blue", "Add animation"', 'ai-site-builder' ); ?></span>
						</div>

						<div class="capability-card">
							<i data-lucide="layout" class="capability-icon"></i>
							<h4><?php _e( 'WordPress Theme Editor', 'ai-site-builder' ); ?></h4>
							<p><?php _e( 'Modify header, footer, navigation, blog design', 'ai-site-builder' ); ?></p>
							<span class="example"><?php _e( 'Examples: "Sticky nav", "Footer columns"', 'ai-site-builder' ); ?></span>
						</div>
					</div>

					<!-- SAFETY & CONTROL -->
					<div class="capability-section">
						<h3><?php _e( 'Safety & Control', 'ai-site-builder' ); ?></h3>

						<div class="capability-card capability-card-compact">
							<i data-lucide="git-branch" class="capability-icon"></i>
							<div class="capability-text">
								<h4><?php _e( 'Version Control', 'ai-site-builder' ); ?></h4>
								<p><?php _e( 'Every change saved • Undo/redo anytime', 'ai-site-builder' ); ?></p>
							</div>
						</div>

						<div class="capability-card capability-card-compact">
							<i data-lucide="eye" class="capability-icon"></i>
							<div class="capability-text">
								<h4><?php _e( 'Draft Mode', 'ai-site-builder' ); ?></h4>
								<p><?php _e( 'Preview changes before publishing', 'ai-site-builder' ); ?></p>
							</div>
						</div>
					</div>

				</div>

				<div class="setup-actions">
					<button type="button" class="btn-primary btn-large" id="start-setup">
						<span><?php _e( "Let's Get Started", 'ai-site-builder' ); ?></span>
						<i data-lucide="arrow-right" class="icon-inline"></i>
					</button>
					<button type="button" class="btn-text" id="skip-welcome">
						<?php _e( 'I know this, skip', 'ai-site-builder' ); ?>
					</button>
				</div>
			</div>
		</div>

		<!-- Step 1: Theme Selection -->
		<div class="setup-step" data-step="1" style="display: none;">
			<div class="setup-header">
				<div class="setup-logo">
					<i data-lucide="sparkles" class="logo-icon"></i>
					<span class="logo-text">Dreamformer</span>
				</div>
				<h1><?php _e( 'Choose Your Base Theme', 'ai-site-builder' ); ?></h1>
				<p class="setup-subtitle"><?php _e( 'Select a WordPress theme for your blog and WooCommerce pages', 'ai-site-builder' ); ?></p>
			</div>

			<div class="setup-content">
				<p class="setup-note">
					<?php _e( 'This provides header/footer for WordPress features (blog posts, WooCommerce). Your AI-generated pages will have independent styling!', 'ai-site-builder' ); ?>
				</p>

				<div class="theme-selection">

					<!-- Base Theme Card -->
					<label class="theme-choice-card">
						<input type="radio" name="base_theme" value="<?php echo esc_attr( AI_SITE_BUILDER_BASE_THEME ); ?>" checked>
						<div class="theme-card-content">
							<div class="theme-preview">
								<div class="preview-icon">
									<i data-lucide="layout-template"></i>
								</div>
							</div>
							<div class="theme-info">
								<h3><?php _e( 'Dreamformer Base', 'ai-site-builder' ); ?></h3>
								<p><?php _e( 'Clean, minimal theme perfect for blogs & business websites', 'ai-site-builder' ); ?></p>
								<ul class="theme-features">
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'Responsive design', 'ai-site-builder' ); ?></li>
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'Blog ready', 'ai-site-builder' ); ?></li>
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'Fast & lightweight', 'ai-site-builder' ); ?></li>
								</ul>
							</div>
						</div>
						<div class="theme-check">
							<i data-lucide="check-circle"></i>
						</div>
					</label>

					<!-- WooCommerce Theme Card -->
					<label class="theme-choice-card">
						<input type="radio" name="base_theme" value="<?php echo esc_attr( AI_SITE_BUILDER_SHOP_THEME ); ?>">
						<div class="theme-card-content">
							<div class="theme-preview">
								<div class="preview-icon">
									<i data-lucide="shopping-bag"></i>
								</div>
							</div>
							<div class="theme-info">
								<h3><?php _e( 'Dreamformer Shop', 'ai-site-builder' ); ?></h3>
								<p><?php _e( 'E-commerce theme with built-in WooCommerce support', 'ai-site-builder' ); ?></p>
								<ul class="theme-features">
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'WooCommerce ready', 'ai-site-builder' ); ?></li>
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'Shopping cart', 'ai-site-builder' ); ?></li>
									<li><i data-lucide="check" class="icon-xs"></i> <?php _e( 'Product pages', 'ai-site-builder' ); ?></li>
								</ul>
							</div>
						</div>
						<div class="theme-check">
							<i data-lucide="check-circle"></i>
						</div>
					</label>

					<!-- Keep Current Theme Card -->
					<label class="theme-choice-card theme-choice-warning">
						<input type="radio" name="base_theme" value="keep_current">
						<div class="theme-card-content">
							<div class="theme-preview">
								<div class="preview-icon">
									<i data-lucide="palette"></i>
								</div>
							</div>
							<div class="theme-info">
								<h3><?php _e( 'Keep Current Theme', 'ai-site-builder' ); ?></h3>
								<p><?php _e( 'Continue using your existing WordPress theme', 'ai-site-builder' ); ?></p>
								<div class="theme-warning">
									<i data-lucide="alert-triangle" class="icon-xs"></i>
									<span><?php _e( 'Not recommended - may have compatibility issues with some themes or page builders', 'ai-site-builder' ); ?></span>
								</div>
							</div>
						</div>
						<div class="theme-check">
							<i data-lucide="check-circle"></i>
						</div>
					</label>

				</div>

				<div class="setup-actions">
					<button type="button" class="btn-secondary" id="back-to-overview">
						<i data-lucide="arrow-left" class="icon-inline"></i>
						<span><?php _e( 'Back', 'ai-site-builder' ); ?></span>
					</button>
					<button type="button" class="btn-primary btn-large" id="complete-setup">
						<i data-lucide="arrow-right" class="icon-inline"></i>
						<span><?php _e( 'Complete Setup', 'ai-site-builder' ); ?></span>
					</button>
				</div>

				<p class="setup-footnote">
					<?php _e( 'You can change this later in WordPress → Appearance → Themes', 'ai-site-builder' ); ?>
				</p>
			</div>
		</div>

		<!-- Step 2: Success + Quick Start Offer -->
		<div class="setup-step setup-success" data-step="2" style="display: none;">
			<div class="success-icon">
				<i data-lucide="check-circle" class="success-check"></i>
			</div>
			<h2><?php _e( 'All Set!', 'ai-site-builder' ); ?></h2>
			<p><?php _e( 'Dreamformer is ready to create amazing pages', 'ai-site-builder' ); ?></p>

			<div class="success-question">
				<p><?php _e( 'Want to see some example prompts to get started?', 'ai-site-builder' ); ?></p>
				<div class="success-actions">
					<button type="button" class="btn-primary btn-large" id="show-quick-start">
						<i data-lucide="lightbulb" class="icon-inline"></i>
						<span><?php _e( 'Show Me Examples', 'ai-site-builder' ); ?></span>
					</button>
					<button type="button" class="btn-secondary" id="skip-quick-start">
						<span><?php _e( "I'll Explore Myself", 'ai-site-builder' ); ?></span>
					</button>
				</div>
			</div>
		</div>

	</div>
</div>

<script>
// Pass WordPress data to JavaScript
window.dreamformerSetup = {
	restUrl: '<?php echo esc_js( rest_url() ); ?>',
	nonce: '<?php echo esc_js( wp_create_nonce( 'wp_rest' ) ); ?>',
	adminUrl: '<?php echo esc_js( admin_url( 'admin.php?page=ai-site-builder' ) ); ?>'
};

// Initialize Lucide icons when ready
jQuery(document).ready(function() {
	if (typeof lucide !== 'undefined') {
		lucide.createIcons();
	}
});
</script>
