<?php
/**
 * Quick Start Box - Dashboard Welcome
 * Shows example prompts for first-time page generation
 * Only appears on first dashboard visit after setup
 *
 * @package AI_Site_Builder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="dreamformer-quick-start">
	<button type="button" class="quick-start-close" id="dismiss-quick-start" title="<?php esc_attr_e( 'Dismiss', 'ai-site-builder' ); ?>">
		<i data-lucide="x"></i>
	</button>

	<div class="quick-start-header">
		<i data-lucide="rocket" class="quick-start-icon"></i>
		<h3><?php _e( 'Welcome! Here are some ideas to get started:', 'ai-site-builder' ); ?></h3>
	</div>

	<div class="quick-start-section">
		<h4><?php _e( 'Try Generating Your First Page:', 'ai-site-builder' ); ?></h4>
		<div class="prompt-suggestions">
			<button type="button" class="prompt-chip" data-prompt="<?php esc_attr_e( 'Create a landing page for a coffee shop with hero section, menu showcase, and contact information', 'ai-site-builder' ); ?>">
				<i data-lucide="coffee" class="chip-icon"></i>
				<span><?php _e( 'Coffee Shop Landing', 'ai-site-builder' ); ?></span>
			</button>
			<button type="button" class="prompt-chip" data-prompt="<?php esc_attr_e( 'Build a complete pricing page with 3 tiers, features list, and FAQ section', 'ai-site-builder' ); ?>">
				<i data-lucide="dollar-sign" class="chip-icon"></i>
				<span><?php _e( 'Pricing Page', 'ai-site-builder' ); ?></span>
			</button>
			<button type="button" class="prompt-chip" data-prompt="<?php esc_attr_e( 'Generate an about us page with company story, team member bios, and values section', 'ai-site-builder' ); ?>">
				<i data-lucide="users" class="chip-icon"></i>
				<span><?php _e( 'About Us Page', 'ai-site-builder' ); ?></span>
			</button>
			<button type="button" class="prompt-chip" data-prompt="<?php esc_attr_e( 'Create a contact page with form, office address map, and social media links', 'ai-site-builder' ); ?>">
				<i data-lucide="mail" class="chip-icon"></i>
				<span><?php _e( 'Contact Page', 'ai-site-builder' ); ?></span>
			</button>
			<button type="button" class="prompt-chip" data-prompt="<?php esc_attr_e( 'Build a portfolio showcase page with project cards, filters, and case study sections', 'ai-site-builder' ); ?>">
				<i data-lucide="briefcase" class="chip-icon"></i>
				<span><?php _e( 'Portfolio Page', 'ai-site-builder' ); ?></span>
			</button>
		</div>
	</div>

	<div class="quick-start-tip">
		<i data-lucide="lightbulb" class="tip-icon"></i>
		<p>
			<?php _e( 'After generating a page, click it to edit elements or access the theme editor.', 'ai-site-builder' ); ?>
		</p>
	</div>
</div>

<script>
jQuery(document).ready(function($) {
	// Initialize Lucide icons
	if (typeof lucide !== 'undefined') {
		lucide.createIcons();
	}

	// Dismiss Quick Start box
	$('#dismiss-quick-start').on('click', async function() {
		const $box = $('.dreamformer-quick-start');

		// Fade out
		$box.fadeOut(300, function() {
			$(this).remove();
		});

		// Mark as dismissed in database
		try {
			await fetch(
				aiSiteBuilder.restUrl + 'ai-builder/v1/setup/dismiss-quick-start',
				{
					method: 'POST',
					headers: {
						'Content-Type': 'application/json',
						'X-WP-Nonce': aiSiteBuilder.nonce
					}
				}
			);
		} catch (error) {
			console.error('Failed to dismiss quick start:', error);
		}
	});

	// Click prompt chip to fill textarea
	$('.prompt-chip').on('click', function() {
		const prompt = $(this).data('prompt');
		const $textarea = $('#page-prompt-input');

		if ($textarea.length) {
			$textarea.val(prompt).focus();

			// Scroll to textarea
			$('html, body').animate({
				scrollTop: $textarea.offset().top - 100
			}, 500);

			// Highlight the textarea
			$textarea.addClass('highlight-prompt');
			setTimeout(() => {
				$textarea.removeClass('highlight-prompt');
			}, 2000);
		}
	});
});
</script>
