/**
 * Celebration System - Make success moments MAGICAL
 * Goal: WONDER + JOY through amazing success celebrations
 */

(function($) {
    'use strict';

    window.DreamformerCelebrations = {
        /**
         * Trigger confetti burst
         */
        confetti: function(options = {}) {
            const defaults = {
                count: 50,
                duration: 3000,
                colors: ['#10b981', '#3b82f6', '#8b5cf6', '#f59e0b', '#f43f5e']
            };
            const settings = { ...defaults, ...options };

            // Create confetti container if it doesn't exist
            let container = $('.confetti-container');
            if (container.length === 0) {
                container = $('<div class="confetti-container"></div>');
                $('body').append(container);
            }

            // Generate confetti pieces
            for (let i = 0; i < settings.count; i++) {
                const confetti = $('<div class="confetti"></div>');

                // Random position
                const left = Math.random() * 100;
                const delay = Math.random() * 0.5;
                const duration = 2 + Math.random() * 2;

                // Random color
                const color = settings.colors[Math.floor(Math.random() * settings.colors.length)];

                confetti.css({
                    left: left + '%',
                    background: color,
                    animationDelay: delay + 's',
                    animationDuration: duration + 's'
                });

                container.append(confetti);

                // Remove after animation
                setTimeout(() => {
                    confetti.remove();
                }, (duration + delay) * 1000);
            }

            // Remove container after all confetti is done
            setTimeout(() => {
                if (container.children().length === 0) {
                    container.remove();
                }
            }, settings.duration);
        },

        /**
         * Trigger sparkle particles around an element
         */
        sparkle: function(element, options = {}) {
            const defaults = {
                count: 12,
                duration: 2000
            };
            const settings = { ...defaults, ...options };

            const $element = $(element);
            const offset = $element.offset();
            const width = $element.outerWidth();
            const height = $element.outerHeight();

            // Create sparkle container
            const container = $('<div class="sparkle-container"></div>');
            container.css({
                position: 'absolute',
                top: offset.top,
                left: offset.left,
                width: width,
                height: height,
                pointerEvents: 'none',
                zIndex: 9999
            });
            $('body').append(container);

            // Generate sparkles
            for (let i = 0; i < settings.count; i++) {
                const sparkle = $('<div class="sparkle"></div>');

                // Random position around the element
                const angle = (Math.PI * 2 * i) / settings.count;
                const distance = 20 + Math.random() * 30;
                const x = Math.cos(angle) * distance + width / 2;
                const y = Math.sin(angle) * distance + height / 2;

                sparkle.css({
                    left: x + 'px',
                    top: y + 'px',
                    animationDelay: (i * 0.1) + 's'
                });

                container.append(sparkle);
            }

            // Remove after animation
            setTimeout(() => {
                container.remove();
            }, settings.duration);
        },

        /**
         * Show milestone popup
         */
        showMilestone: function(title, message, options = {}) {
            const defaults = {
                duration: 3000,
                icon: '🎉'
            };
            const settings = { ...defaults, ...options };

            const popup = $(`
                <div class="milestone-popup">
                    <h2>${settings.icon} ${title}</h2>
                    <p>${message}</p>
                </div>
            `);

            $('body').append(popup);

            // Trigger confetti
            this.confetti({ count: 100 });

            // Remove after duration
            setTimeout(() => {
                popup.fadeOut(400, function() {
                    $(this).remove();
                });
            }, settings.duration);
        },

        /**
         * Show level up animation
         */
        levelUp: function(level, options = {}) {
            const defaults = {
                duration: 2000
            };
            const settings = { ...defaults, ...options };

            const levelUpText = $(`<div class="level-up">LEVEL ${level}!</div>`);
            $('body').append(levelUpText);

            // Play confetti
            this.confetti({ count: 80 });

            // Remove after animation
            setTimeout(() => {
                levelUpText.remove();
            }, settings.duration);
        },

        /**
         * Show success burst on an element
         */
        successBurst: function(element) {
            const $element = $(element);

            // Add burst class temporarily
            $element.addClass('success-burst');

            setTimeout(() => {
                $element.removeClass('success-burst');
            }, 600);
        },

        /**
         * Show combo counter for rapid actions
         */
        showCombo: function(count) {
            let comboCounter = $('.combo-counter');

            if (comboCounter.length === 0) {
                comboCounter = $(`
                    <div class="combo-counter">
                        <span class="combo-label">COMBO</span>
                        <span class="combo-number">${count}</span>
                        <span class="combo-x">×</span>
                    </div>
                `);
                $('body').append(comboCounter);
            } else {
                comboCounter.find('.combo-number').text(count).addClass('animate-pop');
                setTimeout(() => {
                    comboCounter.find('.combo-number').removeClass('animate-pop');
                }, 300);
            }

            // Auto-hide after 3 seconds
            clearTimeout(this.comboTimeout);
            this.comboTimeout = setTimeout(() => {
                comboCounter.fadeOut(300, function() {
                    $(this).remove();
                });
            }, 3000);
        },

        /**
         * Add shimmer effect to element
         */
        shimmer: function(element) {
            const $element = $(element);
            $element.addClass('shimmer');

            setTimeout(() => {
                $element.removeClass('shimmer');
            }, 2000);
        },

        /**
         * Add rainbow border to element
         */
        rainbowBorder: function(element, duration = 3000) {
            const $element = $(element);
            $element.addClass('rainbow-border');

            setTimeout(() => {
                $element.removeClass('rainbow-border');
            }, duration);
        },

        /**
         * Show floating hearts
         */
        hearts: function(element, count = 5) {
            const $element = $(element);
            const offset = $element.offset();
            const width = $element.outerWidth();
            const height = $element.outerHeight();

            for (let i = 0; i < count; i++) {
                const heart = $('<div class="floating-heart">❤️</div>');

                const x = offset.left + Math.random() * width;
                const y = offset.top + height / 2;

                heart.css({
                    left: x + 'px',
                    top: y + 'px',
                    animationDelay: (i * 0.2) + 's'
                });

                $('body').append(heart);

                setTimeout(() => {
                    heart.remove();
                }, 2000);
            }
        },

        /**
         * Show star burst
         */
        starBurst: function(element) {
            const $element = $(element);
            const offset = $element.offset();
            const width = $element.outerWidth();
            const height = $element.outerHeight();

            const burst = $('<div class="star-burst"></div>');
            burst.css({
                left: offset.left + width / 2 + 'px',
                top: offset.top + height / 2 + 'px'
            });

            $('body').append(burst);

            setTimeout(() => {
                burst.remove();
            }, 1000);
        },

        /**
         * Celebrate theme/page save
         */
        celebrateSave: function(element) {
            this.successBurst(element);
            this.sparkle(element, { count: 8 });
        },

        /**
         * Celebrate AI completion
         */
        celebrateAICompletion: function() {
            this.confetti({ count: 30, colors: ['#8b5cf6', '#3b82f6', '#10b981'] });
        },

        /**
         * Celebrate first page/theme
         */
        celebrateFirstCreation: function() {
            this.showMilestone(
                'First Creation!',
                'You\'re off to an amazing start! 🚀',
                { icon: '🎉', duration: 4000 }
            );
        },

        /**
         * Celebrate milestone (5th, 10th, etc. page/theme)
         */
        celebrateMilestone: function(count) {
            let message = '';
            let icon = '🎉';

            if (count === 5) {
                message = 'You\'ve created 5 amazing pages!';
                icon = '🌟';
            } else if (count === 10) {
                message = 'Double digits! 10 creations!';
                icon = '🚀';
            } else if (count === 25) {
                message = '25 creations! You\'re a power user!';
                icon = '⚡';
            } else if (count === 50) {
                message = 'Half century! 50 incredible creations!';
                icon = '🏆';
            } else if (count === 100) {
                message = 'CENTURY! You\'re a Dreamformer legend!';
                icon = '👑';
            } else {
                return; // Don't celebrate other numbers
            }

            this.showMilestone('Milestone Reached!', message, { icon, duration: 5000 });
        },

        /**
         * Show power user badge
         */
        showPowerUserBadge: function() {
            const badge = $('<div class="power-user-badge">Power User</div>');
            badge.css({
                position: 'fixed',
                top: '20px',
                right: '20px',
                zIndex: 10000
            });

            $('body').append(badge);

            setTimeout(() => {
                badge.fadeOut(400, function() {
                    $(this).remove();
                });
            }, 3000);
        },

        /**
         * Impact flash on element
         */
        impactFlash: function(element) {
            const $element = $(element);
            $element.addClass('impact-flash');

            setTimeout(() => {
                $element.removeClass('impact-flash');
            }, 400);
        },

        /**
         * Glow pulse effect
         */
        glowPulse: function(element, duration = 2000) {
            const $element = $(element);
            $element.addClass('glow-pulse');

            setTimeout(() => {
                $element.removeClass('glow-pulse');
            }, duration);
        }
    };

    // Auto-hooks DISABLED - celebrations are now triggered manually from theme-editor.js
    // This prevents interference with streaming and chat functionality

})(jQuery);
